/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSBuriableConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_4966;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6622;
import net.minecraft.class_6834;

public class BuriableStructure<C extends RSBuriableConfig>
extends AbstractBaseStructure<C> {
    public BuriableStructure(Codec<C> codec) {
        super(codec, BuriableStructure::isFeatureChunk, BuriableStructure::generatePieces);
    }

    protected static <CC extends RSBuriableConfig> boolean isFeatureChunk(class_6834.class_6835<CC> context) {
        RSBuriableConfig config = (RSBuriableConfig)context.comp_310();
        if (config.cannotSpawnInWater) {
            class_2338 cornerOfSpawnChunk = context.comp_309().method_8323();
            int landHeight = context.comp_306().method_18028(cornerOfSpawnChunk.method_10263(), cornerOfSpawnChunk.method_10260(), class_2902.class_2903.field_13194, context.comp_311());
            class_4966 columnOfBlocks = context.comp_306().method_26261(cornerOfSpawnChunk.method_10263(), cornerOfSpawnChunk.method_10260(), context.comp_311());
            class_2680 topBlock = columnOfBlocks.method_32892(cornerOfSpawnChunk.method_10264() + landHeight);
            return topBlock.method_26227().method_15769();
        }
        return true;
    }

    public static <CC extends RSBuriableConfig> Optional<class_6622<CC>> generatePieces(class_6834.class_6835<CC> context) {
        class_2338 blockpos = new class_2338(context.comp_309().method_8326(), context.comp_306().method_16398(), context.comp_309().method_8328());
        RSBuriableConfig config = (RSBuriableConfig)context.comp_310();
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new class_3812(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.comp_314()), blockpos, false, false, Integer.MAX_VALUE, Integer.MIN_VALUE, (structurePiecesBuilder, pieces) -> {
            GeneralUtils.centerAllPieces(blockpos, pieces);
            class_2902.class_2903 heightMapToUse = config.useOceanHeightmap ? class_2902.class_2903.field_13195 : class_2902.class_2903.field_13194;
            class_3341 box = ((class_3790)pieces.get(0)).method_14935();
            int highestLandPos = context.comp_306().method_18028(box.method_35415(), box.method_35417(), heightMapToUse, context.comp_311());
            highestLandPos = Math.min(highestLandPos, context.comp_306().method_18028(box.method_35415(), box.method_35420(), heightMapToUse, context.comp_311()));
            highestLandPos = Math.min(highestLandPos, context.comp_306().method_18028(box.method_35418(), box.method_35417(), heightMapToUse, context.comp_311()));
            highestLandPos = Math.min(highestLandPos, context.comp_306().method_18028(box.method_35418(), box.method_35420(), heightMapToUse, context.comp_311()));
            if (config.useOceanHeightmap) {
                int maxHeightForSubmerging = context.comp_306().method_16398() - box.method_14660();
                highestLandPos = Math.min(highestLandPos, maxHeightForSubmerging);
            }
            class_2919 random = new class_2919((class_5819)new class_5820(0L));
            random.method_12663(context.comp_308(), context.comp_309().field_9181, context.comp_309().field_9180);
            int heightDiff = highestLandPos - box.method_35416();
            for (class_3443 structurePiece : pieces) {
                structurePiece.method_14922(0, heightDiff + config.offsetAmount, 0);
            }
        });
    }
}

